################################################################################
#
# Matlab package, version 2.0
#
# This is a set of TCL proc's that allow the shareware Macintosh text editor 
# Alpha to act as a front end for MATLAB for Macintosh version 5.0 or 
# higher.  Requires Alpha 7.0 or higher.  See file "Matlab Help" for more 
# information.
#
################################################################################

alpha::mode MATL 2.0.5 dummyMATL {*.m *.M} {
    MATLMenu electricTab electricSemicolon
} {
    alpha::package require AlphaTcl 7.2.2fc1
    addMenu MATLMenu "405" MATL
    set unixMode(matlab) MATL
    newPref sig matlabSig {MATL}
} maintainer {
    "Stephen M. Merkowitz" Stephen.Merkowitz@lnf.infn.it
} uninstall this-directory help {
    file "Matlab Help"
}


#################################################################################
# Autoload procedures
################################################################################

proc dummyMATL {} {}
proc MATLMenu  {} {}


#################################################################################
# Hooks
################################################################################

namespace eval MATL {}
hook::register saveHook MATL::saveHook MATL

################################################################################
# Flags and variables
################################################################################

newPref v prefixString     {% }     MATL
newPref v wordBreak        {[_\w]+} MATL
newPref v wordBreakPreface {[^_\w]} MATL
newPref f wordWrap         {0}      MATL

newPref v tabSize  {3} MATL
newPref v funcExpr {^[ \t]*(function|FUNCTION).*\(.*$} MATL

newPref f elecReturn   1 MATL
# remove obsolete
catch {unset MATLmodeVars(electricSemi)}

newPref f DblClickEdits  0 MATL
newPref f clearOnSave    0 MATL
newPref f webHelp        0 MATL

newPref v CmdWinName     {*Matlab Commands*} MATL
newPref v CmdHistWinName {*Command History*} MATL

newPref v MatlabHelpFolder "" MATL

newPref f queEventsQuietly  0 MATL


set MATL::commentCharacters(General) "% "
set MATL::commentCharacters(Paragraph) [list "% " "% " "% "]
set MATL::commentCharacters(Box) [list "%" 1 "%" 1 "%" 3]


################################################################################
# Colorization
################################################################################

newPref color keywordColor      blue    MATL
newPref color keyVariablesColor green   MATL
newPref color punctuationColor  magenta MATL

set matKeywords { 
	break else elseif end for if return while function switch case otherwise
	global eval feval nargchk pause menu keyboard input ...
}

set matKeyVariables { 
	ans computer eps flops inf NaN pi realmax realmin 
	nargin nargout varargout varargin
}

regModeKeywords -e {%} -c red -k $MATLmodeVars(keywordColor) MATL $matKeywords  \
	-i {[} -i {]} -i {(} -i {)} -i {,} -i {;} -I $MATLmodeVars(punctuationColor)

regModeKeywords -a -k $MATLmodeVars(keyVariablesColor) MATL $matKeyVariables

unset matKeywords
unset matKeyVariables


################################################################################
#  global variables
################################################################################

set commandHistory [list]
set commandNum 0
set lastMatlabResult ""
set matlabBusy 0
set MATLeventQue [list]


################################################################################
#  Bind some keys
################################################################################

Bind '\r' <z>  matlabDoLine              "MATL"
Bind up        matlabUp                  "MATL"
Bind down      matlabDown                "MATL"
Bind 'u'  <z>  matlabCancelLine          "MATL"
Bind '\;' <o>  MATL::electricSemiJump    "MATL"
Bind '\r'      bind::MATLcarriageReturn  "MATL"


################################################################################
#  Load the rest of the matlab package
################################################################################

foreach f {Comm Engine Macros Menu Windows Doc HTML Completions} {
	 if [catch [set f "matlab${f}.tcl"]] {
		  alertnote "Loading of $f failed!"
	 }
}
unset f
